/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.mariadb.jdbc.type;

import java.util.Arrays;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Geometry;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.LineString;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Point;
import net.impactdev.impactor.relocations.org.mariadb.jdbc.type.Polygon;

public class MultiPolygon
implements Geometry {
    private final Polygon[] polygons;

    public MultiPolygon(Polygon[] polygons) {
        this.polygons = polygons;
    }

    public Polygon[] getPolygons() {
        return this.polygons;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MULTIPOLYGON(");
        int indexpoly = 0;
        for (Polygon poly : this.polygons) {
            if (indexpoly++ > 0) {
                sb.append(",");
            }
            sb.append("(");
            int indexLine = 0;
            for (LineString ls : poly.getLines()) {
                if (indexLine++ > 0) {
                    sb.append(",");
                }
                sb.append("(");
                int index = 0;
                for (Point pt : ls.getPoints()) {
                    if (index++ > 0) {
                        sb.append(",");
                    }
                    sb.append(pt.getX()).append(" ").append(pt.getY());
                }
                sb.append(")");
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MultiPolygon)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.polygons);
    }
}

